unit Form_iklan;

interface
                                               
uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, BusinessSkinForm, ComCtrls, bsSkinCtrls, bsSkinShellCtrls,
  MMObj, MMBmpLst, MMBmpBtn, StdCtrls, ExtCtrls, MMPanel, MMFill,
  bsSkinBoxCtrls, bsfilectrl, Grids, BaseGrid, AdvGrid, AdvCGrid, MMDSPObj,
  MMWavOut, MMPitch, MMAudio,mmmpeg, Mask;

type
  TFormIklan = class(TForm)
    bsBusinessSkinForm1: TbsBusinessSkinForm;
    bsSkinPanel1: TbsSkinPanel;
    bsSkinPanel2: TbsSkinPanel;
    bsSkinPanel3: TbsSkinPanel;
    bsSkinPanel4: TbsSkinPanel;
    MainPanel: TbsSkinPanel;
    MusicExplorer: TbsSkinPanel;
    MMPanelFill9: TMMPanelFill;
    Label1: TLabel;
    bsSkinScrollBar1: TbsSkinScrollBar;
    MMPanelFill15: TMMPanelFill;
    Label3: TLabel;
    MMPanelFill16: TMMPanelFill;
    btn_play: TMMBitmapButton;
    btn_stop: TMMBitmapButton;
    MMPanelFill1: TMMPanelFill;
    Label4: TLabel;
    MMPanelFill2: TMMPanelFill;
    Label5: TLabel;
    MMPanelFill3: TMMPanelFill;
    Label6: TLabel;
    MMPanelFill4: TMMPanelFill;
    MMBitmapButton1: TMMBitmapButton;
    MMBitmapButton2: TMMBitmapButton;
    musiclibtree: TbsSkinTreeView;
    Memo1: TMemo;
    treeGrid: TAdvColumnGrid;
    bsSkinPanel5: TbsSkinPanel;
    filelistbox: TbsSkinFileListView;
    MMPanelFill5: TMMPanelFill;
    audiofile: TMMAudioFile;
    pitch: TMMPitch;
    waveout: TMMWaveOut;
    SCHEDULE: TAdvColumnGrid;
    startdate: TbsSkinDateEdit;
    endate: TbsSkinDateEdit;
    Label2: TLabel;
    Label7: TLabel;
    repeatday: TbsSkinCheckComboBox;
    Label8: TLabel;
    Label9: TLabel;
    airtime: TDateTimePicker;
    Label10: TLabel;
    customer: TbsSkinComboBox;
    MMBitmapButton3: TMMBitmapButton;
    tmrRefresh: TTimer;
    procedure musiclibtreeChange(Sender: TObject; Node: TTreeNode);
    procedure Label6Click(Sender: TObject);
    procedure btn_playClick(Sender: TObject);
    procedure btn_stopClick(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure MMBitmapButton3Click(Sender: TObject);
    procedure MMBitmapButton1Click(Sender: TObject);
    procedure MMBitmapButton2Click(Sender: TObject);
    procedure SCHEDULEClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure tmrRefreshTimer(Sender: TObject);
  private
    { Private declarations }
  public
    procedure cekcolor;
    procedure addtoplaylist(index:integer);
    procedure db2tab;
    { Public declarations }
  end;

var
  FormIklan: TFormIklan;
  prelaunch:array[0..5] of string;
  prelaunchindex:integer;

implementation

uses form_mainform, Form_LibraryEditor, Form_playlist;

{$R *.dfm}

procedure TFormIklan.musiclibtreeChange(Sender: TObject; Node: TTreeNode);
begin
  if musiclibtree.Selected.Selected=true then
  if musiclibtree.Items.Count>0 then
     begin
      if musiclibtree.Selected.Selected then
      if musiclibtree.Selected.AbsoluteIndex>=0 then
      begin
        treegrid.Row:=musiclibtree.Selected.AbsoluteIndex+1;
        if directoryexists(treegrid.Cells[1,treegrid.row])=true then
           begin
            filelistbox.Path:=treegrid.Cells[1,treegrid.row];
            filelistbox.Update;
           end;
      end;
     end;
end;

procedure drawtree(filename:string);
var i,j:integer;
    space:string;
begin
  if filename<>'' then
  begin
  with FormIklan do
  begin
   memo1.Lines.Clear;

   for i:=1 to treegrid.RowCount-1 do
   begin
      if treegrid.Cells[2,i]<>'' then
      begin
        space:='';
        if strtoint(treegrid.Cells[2,i])>1 then
        begin
          for j:=1 to strtoint(treegrid.Cells[2,i])-1 do
          begin
            space:=space+' ';
          end;
        end;
        memo1.Lines.Add(space+treegrid.Cells[0,i]);
      end;
   end;

   memo1.Lines.SaveToFile(savedir+'temp');
   MusicLibTree.LoadFromFile(savedir+'temp');

   MusicLibTree.FullExpand;

   if filename<>'' then
      Treegrid.SaveTofile(workdir+'Share\'+filename);
  end;
  end;
end;

procedure TFormIklan.Label6Click(Sender: TObject);
var i:integer;
begin
  MusicLibTree.Items.Clear;
  MusicLibTree.Update;
  MusicLibTree.Refresh;

  Memo1.Lines.Clear;

  treegrid.ClearRows(1,treegrid.RowCount);
  treegrid.RowCount:=2;

  mainform.tree_commercial.First;
  while not mainform.tree_commercial.Eof do
  begin
    if  treegrid.cells[0,1]<>'' then  treegrid.rowcount:= treegrid.rowcount+1;
        treegrid.cells[0,treegrid.rowcount-1]:=mainform.tree_commercial.FieldByName('List').AsString;
        treegrid.cells[1,treegrid.rowcount-1]:=mainform.tree_commercial.FieldByName('Path').AsString;
        treegrid.cells[2,treegrid.rowcount-1]:=mainform.tree_commercial.FieldByName('Indeks').AsString;
        mainform.tree_commercial.Next;
  end;

  {
  mainform.tree_commercial.First;
  while not mainform.tree_commercial.Eof do
  begin
      Memo1.Lines.Add(mainform.tree_commercial.FieldByName('List').AsString);
      mainform.tree_commercial.Next;
  end;
  Memo1.Lines.SaveToFile(workdir+'Share\commercialslib.dat');
  treeGrid.LoadFromFile(workdir+'Share\commercialslib.dat');
  }
  
  if treeGrid.RowCount<2 then treeGrid.RowCount:=2;


  drawtree('commercialslib.dat');
end;

procedure TFormIklan.btn_playClick(Sender: TObject);
begin
    if fileexists(filelistbox.GetSelectedFile) then
    begin
      if IsMpegFile(filelistbox.GetSelectedFile) then
      begin
        audiofile.FileName :=filelistbox.GetSelectedFile;
        audiofile.FadeOutDuration:=1000;
        audiofile.FadeInDuration:=500;
        WaveOut.Input := audiofile;
        waveout.Stop;
        waveout.Started;
      end;
    end else
    begin
      if languages=0 then mainform.message.MessageDlg('File doesnt exists!',mtconfirmation,[mbok],0);
      if languages=1 then mainform.message.MessageDlg('File tidak ditemukan!',mtconfirmation,[mbok],0);
    end;
end;

procedure TFormIklan.btn_stopClick(Sender: TObject);
begin
    audiofile.FadeOut(audiofile.FadeOutDuration);
end;

procedure TFormIklan.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  width:=0;
  height:=0;
  repeat
    formiklan.FormStyle:=fsnormal;
  until formiklan.FormStyle=fsnormal;
  formiklan.Visible:=false;
  mainform.AutoArrange1.Click;
end;

procedure TFormIklan.cekcolor;
var i:integer;
begin
  for i:=1 to schedule.rowcount-1 do
  begin
    if strtodate(schedule.Cells[2,i])<=date then schedule.RowColor[i]:=clred else schedule.RowColor[i]:=clwhite;
  end;
end;

procedure  TFormIklan.addtoplaylist(index:integer);
begin
  with playlist do
  begin
   tmrRefresh.Enabled:=false;
   if formiklan.schedule.Cells[13,index]<>'' then
   begin
       if (formiklan.schedule.Cells[4,index]+formiklan.schedule.Cells[13,index] <> prelaunch[0]) and
          (formiklan.schedule.Cells[4,index]+formiklan.schedule.Cells[13,index] <> prelaunch[1]) and
          (formiklan.schedule.Cells[4,index]+formiklan.schedule.Cells[13,index] <> prelaunch[2]) and
          (formiklan.schedule.Cells[4,index]+formiklan.schedule.Cells[13,index] <> prelaunch[3]) and
          (formiklan.schedule.Cells[4,index]+formiklan.schedule.Cells[13,index] <> prelaunch[4]) and
          (formiklan.schedule.Cells[4,index]+formiklan.schedule.Cells[13,index] <> prelaunch[5]) then
       begin
          prelaunch[prelaunchindex] :=formiklan.schedule.Cells[4,index]+formiklan.schedule.Cells[13,index];


          if Playlist.Playlistgrid.Cells[0,1]='' then
          begin
            playlistgrid.cells[1,1]:=extractfilename(formiklan.schedule.Cells[13,index]);
            playlistgrid.Cells[5,1]:=formiklan.schedule.Cells[13,index];
            playlistgrid.Cells[0,1]:='WAITING';
            playlistgrid.Cells[6,1]:='COMMERCIALS';
            playlistgrid.Cells[3,1]:='60000';
            playlistgrid.Cells[2,1]:=MSecToTime(60000);
          end else
          if playlistindex=Playlist.Playlistgrid.RowCount-1 then
          begin
            Playlist.Playlistgrid.RowCount:=Playlist.Playlistgrid.RowCount+1;
            playlistgrid.cells[1,Playlist.Playlistgrid.RowCount-1]:=extractfilename(formiklan.schedule.Cells[13,index]);
            playlistgrid.Cells[5,Playlist.Playlistgrid.RowCount-1]:=formiklan.schedule.Cells[13,index];
            playlistgrid.Cells[0,Playlist.Playlistgrid.RowCount-1]:='WAITING';
            playlistgrid.Cells[6,Playlist.Playlistgrid.RowCount-1]:='COMMERCIALS';
            playlistgrid.Cells[3,Playlist.Playlistgrid.RowCount-1]:='60000';
            playlistgrid.Cells[2,Playlist.Playlistgrid.RowCount-1]:=MSecToTime(60000);
          end else
          begin
            playlistgrid.InsertRows(playlistindex+1,1);
            playlistgrid.cells[1,playlistindex+1]:=extractfilename(formiklan.schedule.Cells[13,index]);
            playlistgrid.Cells[5,playlistindex+1]:=formiklan.schedule.Cells[13,index];
            playlistgrid.Cells[0,playlistindex+1]:='WAITING';
            playlistgrid.Cells[6,playlistindex+1]:='COMMERCIALS';
            playlistgrid.Cells[3,playlistindex+1]:='60000';
            playlistgrid.Cells[2,playlistindex+1]:=MSecToTime(60000);
          end;


          //mpegfile.FreeMpeg;
          //mpegfile.FileName:=formiklan.schedule.Cells[13,index];
          //playlistgrid.Cells[3,playlistindex+1]:=inttostr  (mpegfile.Frames * mpegfile.TimePerFrame);
          //playlistgrid.Cells[2,playlistindex+1]:=MSecToTime(mpegfile.Frames * mpegfile.TimePerFrame);
          
          //mpegfile.FreeMpeg;

          cek_total;
          playlistindex:=mainform.getindex;
          mainform.settimeup(playlistindex);
          mainform.playlist_color;
          playlist.Playlistgrid.SaveTofile(savedir+'setting\playlist.dat');

          inc(prelaunchindex);
          if prelaunchindex>5 then prelaunchindex:=0;
       end;
   end;
   tmrRefresh.Enabled:=true;
  end;
end;

procedure TFormIklan.db2tab;
var i:Integer;
begin
    mainform.db_comsched.Refresh;
    FormIklan.SCHEDULE.ClearRows(1,FormIklan.SCHEDULE.RowCount);
    FormIklan.SCHEDULE.RowCount:=2;
    mainform.db_comsched.First;
    while not mainform.db_comsched.Eof do
    begin
        if FormIklan.SCHEDULE.Cells[0,1]<>'' then FormIklan.SCHEDULE.RowCount:=FormIklan.SCHEDULE.RowCount+1;
        FormIklan.SCHEDULE.Cells[0,FormIklan.SCHEDULE.RowCount-1]:=mainform.db_comsched.FieldByName('No').AsString;
        FormIklan.SCHEDULE.Cells[1,FormIklan.SCHEDULE.RowCount-1]:=mainform.db_comsched.FieldByName('Start').AsString;
        FormIklan.SCHEDULE.Cells[2,FormIklan.SCHEDULE.RowCount-1]:=mainform.db_comsched.FieldByName('End').AsString;
        FormIklan.SCHEDULE.Cells[3,FormIklan.SCHEDULE.RowCount-1]:=mainform.db_comsched.FieldByName('File').AsString;
        FormIklan.SCHEDULE.Cells[4,FormIklan.SCHEDULE.RowCount-1]:=mainform.db_comsched.FieldByName('Onair').AsString;
        FormIklan.SCHEDULE.Cells[5,FormIklan.SCHEDULE.RowCount-1]:=mainform.db_comsched.FieldByName('Customer').AsString;
        FormIklan.SCHEDULE.Cells[6,FormIklan.SCHEDULE.RowCount-1]:=mainform.db_comsched.FieldByName('Sun').AsString;
        FormIklan.SCHEDULE.Cells[7,FormIklan.SCHEDULE.RowCount-1]:=mainform.db_comsched.FieldByName('Mon').AsString;
        FormIklan.SCHEDULE.Cells[8,FormIklan.SCHEDULE.RowCount-1]:=mainform.db_comsched.FieldByName('Tue').AsString;
        FormIklan.SCHEDULE.Cells[9,FormIklan.SCHEDULE.RowCount-1]:=mainform.db_comsched.FieldByName('Wed').AsString;
        FormIklan.SCHEDULE.Cells[10,FormIklan.SCHEDULE.RowCount-1]:=mainform.db_comsched.FieldByName('Thu').AsString;
        FormIklan.SCHEDULE.Cells[11,FormIklan.SCHEDULE.RowCount-1]:=mainform.db_comsched.FieldByName('Fri').AsString;
        FormIklan.SCHEDULE.Cells[12,FormIklan.SCHEDULE.RowCount-1]:=mainform.db_comsched.FieldByName('Sat').AsString;
        FormIklan.SCHEDULE.Cells[13,FormIklan.SCHEDULE.RowCount-1]:=mainform.db_comsched.FieldByName('Realname').AsString;
        mainform.db_comsched.Next;
    end;

end;

procedure tab2db;
var i:integer;
begin
  mainform.db_comsched.EmptyTable;
  for i:=1 to FormIklan.SCHEDULE.RowCount-1 do
  begin
    mainform.db_comsched.Append;
    mainform.db_comsched.FieldByName('RBO_ID').AsString:=RBO_ID;
    mainform.db_comsched.FieldByName('No').AsString:=FormIklan.SCHEDULE.Cells[0,i];
    mainform.db_comsched.FieldByName('Start').AsString:=FormIklan.SCHEDULE.Cells[1,i];
    mainform.db_comsched.FieldByName('End').AsString:=FormIklan.SCHEDULE.Cells[2,i];
    mainform.db_comsched.FieldByName('File').AsString:=FormIklan.SCHEDULE.Cells[3,i];
    mainform.db_comsched.FieldByName('Onair').AsString:=FormIklan.SCHEDULE.Cells[4,i];
    mainform.db_comsched.FieldByName('Customer').AsString:=FormIklan.SCHEDULE.Cells[5,i];
    mainform.db_comsched.FieldByName('Sun').AsString:=FormIklan.SCHEDULE.Cells[6,i];
    mainform.db_comsched.FieldByName('Mon').AsString:=FormIklan.SCHEDULE.Cells[7,i];
    mainform.db_comsched.FieldByName('Tue').AsString:=FormIklan.SCHEDULE.Cells[8,i];
    mainform.db_comsched.FieldByName('Wed').AsString:=FormIklan.SCHEDULE.Cells[9,i];
    mainform.db_comsched.FieldByName('Thu').AsString:=FormIklan.SCHEDULE.Cells[10,i];
    mainform.db_comsched.FieldByName('Fri').AsString:=FormIklan.SCHEDULE.Cells[11,i];
    mainform.db_comsched.FieldByName('Sat').AsString:=FormIklan.SCHEDULE.Cells[12,i];
    mainform.db_comsched.FieldByName('Realname').AsString:=FormIklan.SCHEDULE.Cells[13,i];
    mainform.db_comsched.Post;
  end;
end;

procedure TFormIklan.MMBitmapButton3Click(Sender: TObject);
var i:integer;
begin
  if fileexists(filelistbox.GetSelectedFile) then
  begin
    if schedule.Cells[0,1]<>'' then schedule.RowCount:=schedule.RowCount+1;
    schedule.Cells[0,schedule.RowCount-1] :=inttostr(schedule.Rowcount-1);
    schedule.Cells[1,schedule.RowCount-1] :=datetostr(startdate.date);
    schedule.Cells[2,schedule.RowCount-1] :=datetostr(endate.date);
    schedule.Cells[3,schedule.RowCount-1] :=extractfilename(filelistbox.GetSelectedFile);
    schedule.Cells[4,schedule.RowCount-1] :=timetostr(airtime.Time);
    schedule.Cells[5,schedule.RowCount-1] :=customer.Text;
    schedule.Cells[13,schedule.RowCount-1]:=filelistbox.GetSelectedFile;
    for i:=0 to repeatday.Items.Count-1 do
    begin
      if repeatday.Checked[i]=true then
       schedule.Cells[6+i,schedule.RowCount-1]:='1' else
       schedule.Cells[6+i,schedule.RowCount-1]:='0';
    end;
    schedule.SortByColumn(3);
    for i:=1 to schedule.RowCount-1 do if schedule.Cells[1,i]<>'' then schedule.Cells[0,i]:=inttostr(i);
    cekcolor;

    tab2db;
    //schedule.SaveTofile(workdir+'share\comsched.dat');
  end else
  begin
    if languages=0 then mainform.message.MessageDlg('Please select file to add!',mtconfirmation,[mbok],0);
    if languages=1 then mainform.message.MessageDlg('Tolong pilih file terlebih dahulu!',mtconfirmation,[mbok],0);
  end;
end;

procedure TFormIklan.MMBitmapButton1Click(Sender: TObject);
var i:integer;
begin
  schedule.Cells[0,schedule.row] :=inttostr(schedule.row);
  schedule.Cells[1,schedule.row] :=datetostr(startdate.date);
  schedule.Cells[2,schedule.row] :=datetostr(endate.date);
  schedule.Cells[4,schedule.row] :=timetostr(airtime.Time);
  schedule.Cells[5,schedule.row] :=customer.Text;
  for i:=0 to repeatday.Items.Count-1 do
  begin
    if repeatday.Checked[i]=true then
       schedule.Cells[6+i,schedule.row]:='1' else
       schedule.Cells[6+i,schedule.row]:='0';
  end;

  schedule.SortByColumn(3);
  for i:=1 to schedule.RowCount-1 do if schedule.Cells[1,i]<>'' then schedule.Cells[0,i]:=inttostr(i);
  cekcolor;
  tab2db;
  //schedule.SaveTofile(workdir+'share\comsched.dat');
end;

procedure TFormIklan.MMBitmapButton2Click(Sender: TObject);
var i:integer;
begin
  if languages=0 then pesan:='Delete this commercial schedule?';
  if languages=1 then pesan:='Hapus iklan dari jadual?';

  if mainform.message.MessageDlg(pesan,mtconfirmation,[mbyes,mbno],0)=mryes then
  begin
    if schedule.RowCount>2 then schedule.RemoveRows(schedule.Row,1) else
       for i:=0 to schedule.Colcount-1 do schedule.Cells[i,1]:='';
    schedule.SortByColumn(3);
    for i:=1 to schedule.RowCount-1 do if schedule.Cells[1,i]<>'' then schedule.Cells[0,i]:=inttostr(i);
    cekcolor;
    tab2db;
    //schedule.SaveTofile(workdir+'share\comsched.dat');
  end;
end;

procedure TFormIklan.SCHEDULEClick(Sender: TObject);
var i:integer;
begin
  if schedule.Cells[0,schedule.Row]<>'' then
  begin
       startdate.date:=strtodate(schedule.Cells[1,schedule.Row]);
       endate.date   :=strtodate(schedule.Cells[2,schedule.Row]);
       airtime.Time  :=strtotime(schedule.Cells[4,schedule.Row]);

       if customer.Items.Count>0 then
          customer.ItemIndex:=customer.Items.IndexOf(schedule.Cells[5,schedule.Row]);

       repeatday.Update;
       for i:=6 to 12 do
       begin
        if schedule.Cells[i,schedule.Row]='1' then repeatday.Checked[i-6]:=true else
                                                   repeatday.Checked[i-6]:=false;
       end;
       repeatday.Update;
  end;
end;

procedure TFormIklan.FormCreate(Sender: TObject);
begin
    prelaunchindex:=0;
end;

procedure TFormIklan.tmrRefreshTimer(Sender: TObject);
var i:Integer;
begin
  for i:=0 to 5 do prelaunch[i]:='';
end;

end.
